<?php
function streamit_breadcrumbs_title_path()
{
  $streamit_options = get_option('streamit_options');

  $title_tag = 'h2';
  if (isset($streamit_options['breadcum_title_tag'])) {
    $title_tag = $streamit_options['breadcum_title_tag'];
  }

  if (is_archive()) {
?>
    <<?php echo esc_html($title_tag); ?> class="title"><?php the_archive_title(); ?></<?php echo esc_html($title_tag); ?>>
    <?php
  } elseif (is_search()) {
    if (have_posts()) : ?>
      <<?php echo esc_html($title_tag); ?> class="title"><?php printf(esc_html__('Search Results for: %s', 'streamit'), '<span>' . get_search_query() . '</span>'); ?></<?php echo esc_html($title_tag); ?>>

    <?php
    else : ?>
      <<?php echo esc_html($title_tag); ?> class="title"><?php esc_html_e('Nothing Found', 'streamit'); ?></<?php echo esc_html($title_tag); ?>>

    <?php
    endif;
  } elseif (is_404()) {

    if (isset($streamit_options['streamit_fourzerofour_title'])) {
    ?>
      <<?php echo esc_html($title_tag); ?> class="title"><?php $four_title = $streamit_options['streamit_fourzerofour_title'];
                                                          echo esc_html($four_title); ?></<?php echo esc_html($title_tag); ?>>
    <?php
    } else {
    ?>
      <<?php echo esc_html($title_tag); ?> class="title"><?php esc_html_e('Oops! That page can not be found.', 'streamit'); ?></<?php echo esc_html($title_tag); ?>>

    <?php
    }
  } elseif (is_home()) { ?>
    <<?php echo esc_html($title_tag); ?> class="title"><?php wp_title(''); ?></<?php echo esc_html($title_tag); ?>>
  <?php
  } else { ?>
    <<?php echo esc_html($title_tag); ?> class="title"><?php single_post_title(); ?></<?php echo esc_html($title_tag); ?>>
  <?php
  }
}

function streamit_breadcrumbs_feature_image()
{
  $streamit_options = get_option('streamit_options');

  $bnurl = '';
  $page_id = get_queried_object_id();

  if (has_post_thumbnail($page_id)) {
    $image_array = wp_get_attachment_image_src(get_post_thumbnail_id($page_id), 'full');
    $bnurl = $image_array[0];
  } else {
    if (is_404()) {
      if (!empty($streamit_options['streamit_404_banner_image']['url'])) {
        $bnurl = $streamit_options['streamit_404_banner_image']['url'];
      }
    } elseif (is_home()) {
      if (!empty($streamit_options['streamit_blog_banner_image']['url'])) {
        $bnurl = $streamit_options['streamit_blog_banner_image']['url'];
      }
    } else {
      if (!empty($streamit_options['streamit_page_banner_image']['url'])) {
        $bnurl = $streamit_options['streamit_page_banner_image']['url'];
      }
    }
  ?>

  <?php
  }
  ?>
  <?php

}

function streamit_custom_breadcrumbs()
{

  $show_on_home = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
  $home = '' . esc_html__('Home', 'streamit') . ''; // text for the 'Home' link
  $show_current = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show

  global $post;
  $home_link = esc_url(home_url());

  if (is_front_page()) {

    if ($show_on_home == 1) echo '<li class="breadcrumb-item"><a href="' . $home_link . '">' . $home . '</a></li>';
  } else {

    echo '<li class="breadcrumb-item"><a href="' . $home_link . '">' . $home . '</a></li> ';

    if (is_home()) {
      echo  '<li class="breadcrumb-item active">' . esc_html__('Blogs', 'streamit') . '</li>';
    } elseif (is_category()) {
      $this_cat = get_category(get_query_var('cat'), false);
      if ($this_cat->parent != 0) echo '<li class="breadcrumb-item">' . get_category_parents($this_cat->parent, TRUE, '  ') . '</li>';
      echo  '<li class="breadcrumb-item active">' . esc_html__('Archive by category : ', 'streamit') . ' "' . single_cat_title('', false) . '" </li>';
    } elseif (is_search()) {
      echo  '<li class="breadcrumb-item active">' . esc_html__('Search results for : ', 'streamit') . ' "' . get_search_query() . '"</li>';
    } elseif (is_day()) {
      echo '<li class="breadcrumb-item"><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ';
      echo '<li class="breadcrumb-item"><a href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . get_the_time('F') . '</a></li>  ';
      echo  '<li class="breadcrumb-item active">' . get_the_time('d') . '</li>';
    } elseif (is_month()) {
      echo '<li class="breadcrumb-item"><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ';
      echo  '<li class="breadcrumb-item active">' . get_the_time('F') . '</li>';
    } elseif (is_year()) {
      echo  '<li class="breadcrumb-item active">' . get_the_time('Y') . '</li>';
    } elseif (is_single() && !is_attachment()) {
      if (get_post_type() != 'post') {
        $post_type = get_post_type_object(get_post_type());
        $slug = $post_type->rewrite;
        if (!empty($slug)) {
          echo '<li class="breadcrumb-item"><a href="' . $home_link . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a></li>';
        }
        if ($show_current == 1) echo '<li class="breadcrumb-item">' . get_the_title() . '</li>';
      } else {
        $cat = get_the_category();
        if (!empty($cat)) {
          $cat = $cat[0];

          if ($show_current == 0) $cats = preg_replace("#^(.+)\s\s$#", "$1", $cats);
          echo '<li class="breadcrumb-item">' . get_category_parents($cat, TRUE, '  ') . '</li>';
          if ($show_current == 1) echo  '<li class="breadcrumb-item active">' . get_the_title() . '</li>';
        }
      }
    } elseif (!is_single() && !is_page() && get_post_type() != 'post' && !is_404()) {
      $post_type = get_post_type_object(get_post_type());
      echo  '<li class="breadcrumb-item active">' . $post_type->labels->singular_name . '</li>';
    } elseif (!is_single() && is_attachment()) {
      $parent = get_post($post->post_parent);
      $cat = get_the_category($parent->ID);
      $cat = $cat[0];
      echo '<li class="breadcrumb-item">' . get_category_parents($cat, TRUE, '  ') . '</li>';
      echo '<li class="breadcrumb-item"><a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li>';
      if ($show_current == 1) echo '<li class="breadcrumb-item active"> ' .  get_the_title() . '</li>';
    } elseif (is_page() && !$post->post_parent) {
      if ($show_current == 1) echo  '<li class="breadcrumb-item active">' . get_the_title() . '</li>';
    } elseif (is_page() && $post->post_parent) {
      $trail = '';
      $page_title = '<li class="breadcrumb-item">' . get_the_title($post->ID) . '</li>';
      if ($post->post_parent) {
        $parent_id = $post->post_parent;

        $breadcrumbs = array();
        while ($parent_id) {
          $page = get_page($parent_id);
          $breadcrumbs[] = '<li class="breadcrumb-item"><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
          $parent_id  = $page->post_parent;
        }
        $breadcrumbs = array_reverse($breadcrumbs);
        foreach ($breadcrumbs as $crumb) $trail .= $crumb;
      }
      $trail .= $page_title;
      $trail .= '

';
      return $trail;
      if ($show_current == 1) echo '<li class="breadcrumb-item active"> ' .  get_the_title() . '</li>';
    } elseif (is_tag()) {
      echo  '<li class="breadcrumb-item active">' . esc_html__('Posts tagged', 'streamit') . ' "' . single_tag_title('', false) . '"</li>';
    } elseif (is_author()) {
      global $author;
      $userdata = get_userdata($author);
      echo  '<li class="breadcrumb-item active">' . esc_html__('Articles posted by : ', 'streamit') . ' ' . $userdata->display_name . '</li>';
    } elseif (is_404()) {
      echo  '<li class="breadcrumb-item active">' . esc_html__('Error 404', 'streamit') . '</li>';
    }

    if (get_query_var('paged')) {
      echo '<li class="breadcrumb-item active">' . esc_html__('Page', 'streamit') . ' ' . get_query_var('paged') . '</li>';
    }
  }
}

// if you don't add 3 as as 4th argument, this will not work as expected

if (isset($_POST['_featured'])) {
  add_action('pre_post_update', 'streamit_save_episode_function', 10, 3);
  add_action('draft_to_publish', 'streamit_save_episode_function');
  function streamit_save_episode_function($post_ID, $post)
  {
    update_post_meta($post_ID, '__featured', $_POST['_featured']);
  }
}

if (!function_exists('streamit_open_popup')) {
  function streamit_open_popup($content)
  {
  ?>
    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
      Launch demo modal
    </button>

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <?php echo do_shortcode($content); ?>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="button" class="btn btn-primary">Save changes</button>
          </div>
        </div>
      </div>
    </div>
<?php
  }
}
// ** search load more *//
if (!function_exists('streamit_loadmore_ajax_handler')) {

  function streamit_loadmore_ajax_handler()
  {
    // prepare our arguments for the query
    $args = json_decode(stripslashes($_POST['query']), true);
    $args['paged'] = $_POST['page'] + 1; // we need next page to be loaded
    $args['post_status'] = 'publish';

    query_posts($args);
    if (have_posts()) :

      // run the loop
      while (have_posts()) : the_post();

        get_template_part('template-parts/post/content', 'search');

      endwhile;

    endif;
    die; // here we exit the script and even no wp_reset_query() required!
  }
}
add_action('wp_ajax_loadmore', 'streamit_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore', 'streamit_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}


//** blog load more *//
if (!function_exists('streamit_loadmore_blog_ajax_handler')) {
  function streamit_loadmore_blog_ajax_handler()
  {
    // prepare our arguments for the query
    $args = json_decode(stripslashes($_POST['query']), true);
    $args['paged'] = $_POST['page'] + 1; // we need next page to be loaded
    $args['post_status'] = 'publish';

    query_posts($args);
    if (have_posts()) :

      // run the loop
      while (have_posts()) : the_post();

        get_template_part('template-parts/post/content', get_post_format());

      endwhile;

    endif;
    die; // here we exit the script and even no wp_reset_query() required!
  }
}
add_action('wp_ajax_loadmore_blog', 'streamit_loadmore_blog_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore_blog', 'streamit_loadmore_blog_ajax_handler'); // wp_ajax_nopriv_{action}