<?php
global $streamit_options;
// TGM plugin activation
require_once get_template_directory() . '/inc/tgm/required-plugins.php';
// Breadcrumbs
require_once get_template_directory() . '/inc/custom/breadcrumbs.php';
// Demo import
require_once get_template_directory() . '/inc/demo/import.php';
// Header Breadcrumbs
require_once get_template_directory() . '/inc/custom/breadcrumbs.php';
// Comment
require_once get_template_directory() . '/inc/custom/comment.php';
// Pagination
require_once get_template_directory() . '/inc/custom/pagination.php';
// Widget
require_once get_template_directory() . '/inc/custom/widget.php';
//Maintenance
require_once get_template_directory() . '/inc/custom/maintenance.php';
// Dynamic Style
require_once get_template_directory() . '/inc/custom/dynamic-style.php';
// StyleSwticher Style
require_once get_template_directory() . '/inc/custom/layout-option.php';
// Color Style
require_once get_template_directory() . '/inc/custom/color-style.php';
require_once get_template_directory() . '/inc/custom/dynamic-style/init.php';
//Healper Function
require_once get_template_directory() . '/inc/custom/helper/helper-functions.php';
require_once get_template_directory() . '/inc/remove-hook/remove-hook.php';
function streamit_custom_fonts_url()
{
	$fonts_url = '';

	/* Translators: If there are characters in your language that are not

	* supported by Roboto, translate this to 'off'. Do not translate
	* into your own language.
	*/

	/* Translators: If there are characters in your language that are not
	* supported by Nunito, translate this to 'off'. Do not translate
	* into your own language.
	*/


	$Heebo = _x('on', 'Heebo: on or off', 'streamit');
	$Roboto = _x('on', 'Roboto: on or off', 'streamit');

	if ('off' !== $Heebo || 'off' !== $Roboto) {
		$font_families = array();




		$font_families[] = 'Heebo:wght@200;300;400;500;600;700;800&family=Roboto:ital,wght@0,400;0,500;0,700;0,900;1,400;1,500;1,700';

		$query_args = array(
			'family' => implode('&family', $font_families),
			'subset' => urlencode('latin,latin-ext'),
		);

		$fonts_url = add_query_arg($query_args, '//fonts.googleapis.com/css2');
	}

	return esc_url_raw($fonts_url);
}

function streamit_load_js_css()
{
	/* Start layout style swticher option */
	global $wp_query;
	$streamit_options = get_option('streamit_options');
	$previewpreset = (isset($_REQUEST['preset']) ? $_REQUEST['preset'] : null);
	if ($previewpreset) {
		$_SESSION["preset"] = $previewpreset;
	}
	if (!isset($_SESSION["preset"])) {
		$_SESSION["preset"] = 1;
	}
	if ($_SESSION["preset"] != 1) {
		if ($streamit_options['streamit_layout_mode_options'] == 2) {
			$presetopt = 1;
			$presetopt1 = 1;
			$presetopt2 = 1;
		} else {
			$presetopt = $_SESSION["preset"];
			$presetopt1 = $_SESSION["preset"];
			$presetopt2 = $_SESSION["preset"];
		}
	} else {
		/* if no preset varialbe found in url, use from theme options */
		$presetopt = isset($streamit_options['streamit_layout_mode_options']) ? $streamit_options['streamit_layout_mode_options'] : 1;
		$presetopt1 = isset($streamit_options['streamit_layout_mode_options']) ? $streamit_options['streamit_layout_mode_options'] : 1;
		$presetopt2 = isset($streamit_options['streamit_layout_mode_options']) ? $streamit_options['streamit_layout_mode_options'] : 1;
	}

	if (!isset($presetopt)) $presetopt = 1; /* in case first time install theme, no options found ...bootstrap*/
	if (!isset($presetopt1)) $presetopt1 = 1; /* in case first time install theme, no options found ...custom*/
	if (!isset($presetopt2)) $presetopt2 = 1; /* in case first time install theme, no options found...responsive */

	/* end layout style swticher option */

	wp_enqueue_script('jquery');
	/* Custom JS */
	wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array(), '4.1.3', true);
	wp_enqueue_script('streamit-custom', get_template_directory_uri() . '/assets/js/streamit-custom.js', array(), '1.0', true);
	wp_enqueue_script('wow', get_template_directory_uri() . '/assets/js/wow.min.js', array(), '1.0', true);
	// wp_enqueue_script('delight', get_template_directory_uri() . '/assets/js/delight.js', array(), '4.1.3', true);

	// loadmore
	wp_register_script('my_loadmore', get_template_directory_uri() . '/assets/js/myloadmore.js', array('jquery'));
	wp_localize_script('my_loadmore', 'streamit_loadmore_params', array(
		'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php', // WordPress AJAX
		'posts' => json_encode($wp_query->query_vars), // everything about your loop is here
		'current_page' => get_query_var('paged') ? get_query_var('paged') : 1,
		'max_page' => $wp_query->max_num_pages
	));
	wp_enqueue_script('my_loadmore');

	/* Custom CSS */
	wp_enqueue_style('streamit-fonts', streamit_custom_fonts_url(), array(), null);

	wp_enqueue_style('wow', get_template_directory_uri() . '/assets/css/wow.css', array(), '4.1.3', 'all');
	/* Custom CSS */
	wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min' . $presetopt . '.css', array(), '4.1.3', 'all');
	wp_enqueue_style('ionicons', get_template_directory_uri() . '/assets/css/ionicons/css/ionicons.min.css', array(), '4.5.10', 'all');
	wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/font-awesome/css/font-awesome.min.css', array(), '4.7.0', 'all');

	// Load main strap css style
	wp_enqueue_style('streamit-style', get_template_directory_uri() . '/assets/css/streamit-style' . $presetopt1 . '.css', array(), '1.0.0', 'all');
	wp_enqueue_style('streamit-responsive', get_template_directory_uri() . '/assets/css/streamit-responsive' . $presetopt2 . '.css', array(), '1.0', 'all');
}
add_action('wp_enqueue_scripts', 'streamit_load_js_css');


if (!function_exists('streamit_dynamic_style')) {

	function streamit_dynamic_style($streamit_css_array)
	{
		foreach ($streamit_css_array as $css_part) {
			if (!empty($css_part['value'])) {
				echo esc_attr($css_part['elements']) . "{\n";
				echo esc_attr($css_part['property']) . ":" . esc_attr($css_part['value']) . ";\n";
				echo "}\n\n";
			}
		}
	}
}

function streamit_categories_postcount_filter($variable)
{
	$variable = str_replace('(', '<span class="post_count"> ', $variable);
	$variable = str_replace(')', ' </span>', $variable);
	return $variable;
}
add_filter('wp_list_categories', 'streamit_categories_postcount_filter');

function streamit_style_the_archive_count($links)
{
	$links = str_replace('</a>&nbsp;(', '</a> <span class="archiveCount">', $links);
	$links = str_replace(')', '</span>', $links);
	return $links;
}
add_filter('get_archives_link', 'streamit_style_the_archive_count');

function streamit_inline_css()
{
	$streamit_options = get_option('streamit_options');
	$custom_style = "";

	if (!empty($streamit_options['streamit_css_code'])) {

		$streamit_css_code = $streamit_options['streamit_css_code'];
		$custom_style = $streamit_css_code;
	}
	wp_add_inline_style('streamit-style', $custom_style);
}
add_action('wp_enqueue_scripts', 'streamit_inline_css', 100);

if (class_exists('MasVideos')) {
	function streamit_pre_get_posts($query)
	{
		if (!is_admin()) {
			if (is_search() && $query->is_main_query()) {
				$query->set('post_type', array('movie', 'tv_show', 'episode', 'video', 'post'));
			}
		}
	}

	add_action('pre_get_posts', 'streamit_pre_get_posts');
}

if (is_user_logged_in()) {
	$user = wp_get_current_user();
	if ($user->roles[0] === 'subscriber') {
		show_admin_bar(false);
	}
}

function hex2RGB($hexStr, $returnAsString = false, $seperator = ',')
{
	$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
	$rgbArray = array();
	if (strlen($hexStr) == 6) { //If a proper hex code, convert using bitwise operation. No overhead... faster
		$colorVal = hexdec($hexStr);
		$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
		$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
		$rgbArray['blue'] = 0xFF & $colorVal;
	} elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
		$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
		$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
		$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
	} else {
		return false; //Invalid hex color code
	}
	return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
}
function my_callback_function()
{
	$test = "<i class='fa fa-user'></i> test";
	return ["test" => $test];
}


//** admin custom css *//
add_action('admin_head', 'streamit_admin_custom_css');

function streamit_admin_custom_css()
{
	echo '<style>
  	.redux-container .ui-buttonset .ui-button {
		height: unset;
    } 
  </style>';
}




// the ajax function search
add_action('wp_ajax_data_fetch', 'data_fetch');
add_action('wp_ajax_nopriv_data_fetch', 'data_fetch');
function data_fetch()
{

	$wp_query = new WP_Query(
		array('posts_per_page' => 5, 's' => esc_attr($_POST['keyword']), 'post_type' => array('movie', 'tv_show', 'episode', 'video', 'post'))
	);
?>
	<div class="widget streamit-ajax-custom-search mb-0 pb-0">
		<div class="list-inline iq-widget-menu">
			<ul class="iq-post">
				<?php
				$genre = '';
				if ($wp_query->have_posts()) :
					while ($wp_query->have_posts()) : $wp_query->the_post();
						if ('movie' == get_post_type() || 'tv_show' == get_post_type()) {
							$wp_object = wp_get_post_terms(get_the_ID(), 'movie_genre');
						} else if ('video' == get_post_type()) {
							$wp_object = wp_get_post_terms(get_the_ID(), 'video_cat');
						} else {
							$wp_object = wp_get_post_terms(get_the_ID(), 'category');
						}
						if (!empty($wp_object)) {
							$k = 1;
							foreach ($wp_object as $val) {

								if ($k == 1)
									$genre = $val->name;
								else
									$genre .= ', ' . $val->name;
								$k++;
							}
						}
						$img_url = wp_get_attachment_image_url(get_post_thumbnail_id(get_the_ID()), "medium");
				?>
						<li class="mr-0 mb-2 pb-0 d-block">
							<div class="post-img">
								<div class="post-img-holder">
									<a class="img-height" href="<?php echo esc_url(get_permalink()); ?>">
										<img src='<?php echo esc_url($img_url, "streamit"); ?>' alt="image" />
									</a>
								</div>
								<div class="post-blog pt-2 pb-2 pr-2">
									<div class="blog-box">
										<a class="new-link" href="<?php echo esc_url(get_permalink()); ?>">
											<h6><?php the_title(); ?></h6>
										</a>

										<ul class="list-inline iq-category-list">
											<li class="list-inline-item"><span><?php echo esc_html(rtrim($genre, ",")); ?></span></li>
										</ul>

									</div>
								</div>
							</div>
						</li>

					<?php endwhile;
					wp_reset_postdata();
					?>

			</ul>
		<?php
				else :
					echo '<p class="no-result pb-2">' . __('No Results Found', 'streamit') . '</p>';
				endif;
		?>
		</div>
	</div>
	<?php
	$tot = $wp_query->found_posts;
	$total_pages = $wp_query->max_num_pages;
	if ($total_pages > 1) { ?>
		<button type="submit" class="hover-buttons btn w-100"><?php esc_html_e('More Results', 'streamit'); ?></button>
	<?php }
	?>
<?php
	die();
}
// add the ajax fetch js
add_action('wp_footer', 'ajax_fetch');
function ajax_fetch()
{
?>
	<script type="text/javascript">
		function fetchResults() {
			var keyword = jQuery('#searchInput').val();
			if (keyword == "") {
				jQuery('#datafetch').html("");
			} else {
				jQuery.ajax({
					url: '<?php echo admin_url('admin-ajax.php'); ?>',
					type: 'post',
					data: {
						action: 'data_fetch',
						keyword: keyword
					},
					success: function(data) {
						jQuery('#datafetch').html(data);
					}
				});
			}


		}
	</script>

<?php
}
