<?php
function streamit_comments( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment;
    switch ( $comment->comment_type ) :
        case 'pingback' :
        case 'trackback' :
            if ( 'div' == $args['style'] ) {
                $tag = 'div';
                $add_below = 'comment';
            } else {
                $tag = 'li';
                $add_below = 'div-comment';
            }
            ?>
            <li <?php comment_class('iq-comments-item'); ?> id="comment-<?php comment_ID(); ?>">
            <h5 class="mt-0 mb-0"> <span class="iq-type-date"><span class="mr-2"><?php echo esc_html__( comment_type().':', 'streamit' ); ?></span><?php comment_author_link(); ?></span> <?php edit_comment_link( esc_html__( '(Edit)', 'streamit' ), '<span class="edit-link">', '</span>' ); ?></h5>
            <div class="iq-comment-type-date">
                <a href="<?php echo esc_url( comment_link(  ) ); ?>">
                    <time datetime="<?php comment_time( 'c' ); ?>">
                        <i class="fa fa-calendar mr-1"></i>
                        <?php printf( wp_kses( '%1$s', '1: date' ), comment_date()); ?>
                    </time>
                </a>
            </div>
            <?php
            break;
        default :
            global $post;
            ?>
        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
            <article id="div-comment-<?php comment_ID(); ?>" class="comment-body">
                <div class="iq-comments-media">
                    <div class="iq-comment-wrap">
                        <div class="iq-comments-photo">
                            <?php if ( 0 != $args['avatar_size'] ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
                        </div>
                        <div class="iq-comments-info">
                            <h4 class="title">
                                <?php printf( wp_kses( '%s ', 'streamit' ), sprintf( '%s', get_comment_author_link() ) ); ?>
                            </h4>

                            <?php if ( '0' == $comment->comment_approved ) : ?>
                                <p class="comment-awaiting-moderation"><?php esc_html__( 'Your comment is awaiting moderation.', 'streamit' ); ?></p>
                            <?php endif; ?>
                            <div class="comment-content">
                                <?php comment_text(); ?>
                            </div><!-- .comment-content -->
                            <div class="iq-comment-metadata">
                                <a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
                                    <time datetime="<?php comment_time( 'c' ); ?>">
                                        <i class="fa fa-calendar mr-1"></i>
                                        <?php printf( wp_kses( '%1$s', '1: date' ), get_comment_date()); ?>
                                    </time>
                                </a>
                            </div>
                            <?php edit_comment_link( esc_html__( 'Edit', 'streamit' ), '<span class="edit-link">', '</span>' ); ?><!-- .comment-metadata -->
                            <div class="reply iq-reply iq-button-style-2 has-icon btn-icon-right">
                                <?php comment_reply_link( array_merge( $args, array( 'add_below' => 'div-comment', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
                            </div><!-- .reply -->
                        </div><!-- .comment-author -->

                    </div>
                </div>
            </article><!-- .comment-body -->
            <?php
            break;
    endswitch;
}