<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage streamit
 * @since 1.0
 * @version 1.2
 */
$streamit_options = get_option('streamit_options'); ?>
</div><!-- #content -->
<!-- Footer start-->
<?php
if(isset($streamit_options['display_footer']))
{
	$options = $streamit_options['display_footer'];
	if($options == "yes")
	{
		if(isset($streamit_options['footer_image']['url'])){
				$bgurl = $streamit_options['footer_image']['url'];
		}
	}
}
?>
<footer id="contact" class="footer-one iq-bg-dark" <?php if(!empty($bgurl)){ ?> style="background-image: url(<?php echo esc_url($bgurl); ?> );" <?php } ?>>
		
     
        <?php

          get_template_part( 'template-parts/footer/footer', 'widgets' );
        
          get_template_part( 'template-parts/footer/site', 'info' );
           
        ?>
     
</footer>
  <!-- Footer stop-->

    </div><!-- .site-content-contain -->
</div><!-- #page -->
<?php
$streamit_options = get_option('streamit_options');
if(isset($streamit_options['streamit_back_to_top']))
{
	$options = $streamit_options['streamit_back_to_top'];
	if($options == "yes")
	{
	?>
	<!-- === back-to-top === -->
	<div id="back-to-top">
		<a class="top" id="top" href="#top"> <i class="ion-ios-arrow-up"></i> </a>
	</div>
	<!-- === back-to-top End === -->
	<?php 
	}
}
else 
{
?>

	<div id="back-to-top">
		<a class="top" id="top" href="#top"> <i class="fa fa-angle-up" aria-hidden="true"></i> </a>
	</div>
	
<?php
}
?>

<?php
if(!empty($streamit_options['streamit_js_code'])){
	wp_register_script( 'decode-handle-footer', '', [], '', true );
	wp_enqueue_script( 'decode-handle-footer'  );
	wp_add_inline_script( 'decode-handle-footer', wp_specialchars_decode($streamit_options['streamit_js_code']) );
}
?>


<?php wp_footer(); ?>
</body>
</html>
