(function (jQuery) {

	jQuery(document).ready(function () {

		var streamit_options = jQuery('.streamit_datapass').data('options');
		var streamit_options_blog = jQuery('.streamit_datapass_blog').data('options');


		if (streamit_options == "load_more") {
			//
			jQuery('.streamit_loadmore_btn').click(function () {
				var button_load = jQuery(this).attr('data-loading-text');
				var button_text = jQuery(this).text();
				var button = jQuery(this),
					data = {
						'action': 'loadmore',
						'query': streamit_loadmore_params.posts, // that's how we get params from wp_localize_script() function
						'page': streamit_loadmore_params.current_page
					};
				jQuery.ajax({ // you can also use jQuery.post here
					url: streamit_loadmore_params.ajaxurl, // AJAX handler
					data: data,
					type: 'POST',
					beforeSend: function (xhr) {
						button.text(button_load); // change the button text, you can also add a preloader image
					},
					success: function (data) {
						if (data) {
							button.text(button_text).prev('div').append(data); // insert new posts
							streamit_loadmore_params.current_page++;

							if (streamit_loadmore_params.current_page == streamit_loadmore_params.max_page)
								button.remove(); // if last page, remove the button

						} else {
							button.remove(); // if no data, remove the button as well
						}
					}
				});
			});
		}	
		if (streamit_options_blog == "load_more") {
			//** blog load more *//
			jQuery('.streamit_loadmore_btn_blog').click(function () {
				var button_load = jQuery(this).attr('data-loading-text');
				var button_text = jQuery(this).text();
				var button = jQuery(this),
					data = {
						'action': 'loadmore_blog',
						'query': streamit_loadmore_params.posts, // that's how we get params from wp_localize_script() function
						'page': streamit_loadmore_params.current_page
					};

				jQuery.ajax({ // you can also use jQuery.post here
					url: streamit_loadmore_params.ajaxurl, // AJAX handler
					data: data,
					type: 'POST',
					beforeSend: function (xhr) {
						button.text(button_load); // change the button text, you can also add a preloader image
					},
					success: function (data) {
						if (data) {

							button.text(button_text).prev().after(data); // insert new posts
							streamit_loadmore_params.current_page++;

							if (streamit_loadmore_params.current_page == streamit_loadmore_params.max_page)
								button.remove(); // if last page, remove the button

						} else {
							button.remove(); // if no data, remove the button as well
						}
					}
				});
			});

		}

	});

	jQuery(function (jQuery) {

		var canBeLoaded = true,
			bottomOffset = 2000; // the distance (in px) from the page bottom when you want to load more posts

		var streamit_options = jQuery('.streamit_datapass').data('options');
		var streamit_options_blog = jQuery('.streamit_datapass_blog').data('options');


		if (streamit_options == "infinite_scroll") {


			jQuery(window).scroll(function () {

				//** search load more *//
				var data = {
					'action': 'loadmore',
					'query': streamit_loadmore_params.posts,
					'page': streamit_loadmore_params.current_page
				};

				if (jQuery(document).scrollTop() > (jQuery(document).height() - bottomOffset) && canBeLoaded == true) {

					jQuery.ajax({
						url: streamit_loadmore_params.ajaxurl,
						data: data,
						type: 'POST',
						beforeSend: function (xhr) {
							canBeLoaded = false;
						},
						success: function (data) {
							if (data) {
								jQuery(".loader-wheel-container").html('<div class="loader-wheel"><i><i><i><i><i><i><i><i><i><i><i><i></i></i></i></i></i></i></i></i></i></i></i></i></div>');
								jQuery('#main').find('article:last-of-type').after(data); // where to insert posts
								canBeLoaded = true; // the ajax is completed, now we can run it again
								streamit_loadmore_params.current_page++;
							} else {
								jQuery(".loader-wheel-container").html('');
							}

						}
					});
				}


			});

		} 
		else {
			//nothing to call
		}
		if (streamit_options_blog == "infinite_scroll") {
			jQuery(window).scroll(function () {

				//** search load more *//
				var data = {
					'action': 'loadmore_blog',
					'query': streamit_loadmore_params.posts,
					'page': streamit_loadmore_params.current_page
				};

				if (jQuery(document).scrollTop() > (jQuery(document).height() - bottomOffset) && canBeLoaded == true) {

					jQuery.ajax({
						url: streamit_loadmore_params.ajaxurl,
						data: data,
						type: 'POST',
						beforeSend: function (xhr) {
							canBeLoaded = false;
						},
						success: function (data) {
							if (data) {
								jQuery(".loader-wheel-container").html('<div class="loader-wheel"><i><i><i><i><i><i><i><i><i><i><i><i></i></i></i></i></i></i></i></i></i></i></i></i></div>');
								jQuery('#main').find('article:last-of-type').after(data); // where to insert posts
								canBeLoaded = true; // the ajax is completed, now we can run it again
								streamit_loadmore_params.current_page++;
							} else {
								jQuery(".loader-wheel-container").html('');
							}

						}
					});
				}


			});
		} else {
			//nothing to call
		}
	});


})(jQuery);