<?php
add_action( 'widgets_init', function(){
    register_widget( 'widget_toroflix_footer_info' );
});
class widget_toroflix_footer_info extends WP_Widget {
    #Sets up the widgets name etc
    public function __construct() {
        $widget_ops = array(
            'classname' => 'widget_textfot',
            'description' => 'Show description, image and social link',
        );
        parent::__construct( 'widget_toroflix_footer_info', 'Toroflix: Info', $widget_ops );
    }
    # Display frontend
    public function widget( $argus, $instance ) {
        echo $argus['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $argus['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $argus['after_title'];
        } ?>
        <?php $texts = isset( $instance['texts'] ) ? $instance['texts'] : false; 
        $image_uri = isset( $instance['image_uri'] ) ? $instance['image_uri'] : false; 
        $facebook    = isset( $instance['facebook'] ) ? $instance['facebook'] : false; 
        $twitter     = isset( $instance['twitter'] ) ? $instance['twitter'] : false; 
        $instagram   = isset( $instance['instagram'] ) ? $instance['instagram'] : false; 
        $youtube     = isset( $instance['youtube'] ) ? $instance['youtube'] : false;  ?>
        <?php if($image_uri){ ?>
        <figure class="Logo"><img src="<?php echo $image_uri; ?>" alt="ToroFlix"></figure><?php } ?>
        <?php if($texts){ ?>
        <p><?php echo $texts; ?></p><?php } ?>
        <ul class="SocialList">
            <?php if($facebook) 
                echo '<li><a target="_blank" href="'.$facebook.'" class="fa-facebook"></a></li>'; ?>
            <?php if($twitter) 
                echo '<li><a target="_blank" href="'.$twitter.'" class="fa-twitter"></a></li>'; ?>
            <?php if($instagram) 
                echo '<li><a target="_blank" href="'.$instagram.'" class="fa-instagram"></a></li>'; ?>
            <?php if($youtube) 
                echo '<li><a target="_blank" href="'.$youtube.'" class="fa-youtube"></a></li>'; ?>
        </ul>
        <?php echo $argus['after_widget'];
    }
    #Parameters Form of Widget
    public function form( $instance ) {
        $title     = ! empty( $instance['title'] ) ? $instance['title'] : '';
        $texts     = isset( $instance['texts'] ) ? $instance['texts'] : '';
        $facebook  = ! empty( $instance['facebook'] ) ? $instance['facebook'] : false;
        $twitter   = ! empty( $instance['twitter'] ) ? $instance['twitter'] : false;
        $instagram = ! empty( $instance['instagram'] ) ? $instance['instagram'] : false;
        $youtube   = ! empty( $instance['youtube'] ) ? $instance['youtube'] : false;
        $image_uri    = ! empty( $instance['image_uri'] ) ? $instance['image_uri'] : false;
        ?>
        <div class="wdgt-tt">
            
            <div>
                <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'toroflix' ); ?></label>
                <div class="fr-input">
                    <span class="dashicons dashicons-edit-large"></span>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
                </div>
                    
            </div>

            <div>
                <label for="<?php echo $this->get_field_id( 'texts' ); ?>"><?php _e( 'Description:', 'toroflix' ); ?></label>
                <div class="fr-input">
                    <textarea placeholder="Description" style="width: 100%;" name="<?php echo $this->get_field_name( 'texts' ); ?>" id="" cols="30" rows="10"><?php echo $texts; ?></textarea>
                </div>
            </div>

            <div>
                <label for="<?php echo $this->get_field_id( 'facebook' ); ?>">Facebook:</label>
                <div class="fr-input">
                    <span class="dashicons dashicons-facebook-alt"></span>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'facebook' ); ?>" name="<?php echo $this->get_field_name( 'facebook' ); ?>" type="text" value="<?php echo esc_attr( $facebook ); ?>">
                </div>
            </div>

            <div>
                <label for="<?php echo $this->get_field_id( 'twitter' ); ?>">Twitter:</label>
                <div class="fr-input">
                    <span class="dashicons dashicons-twitter"></span>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'twitter' ); ?>" name="<?php echo $this->get_field_name( 'twitter' ); ?>" type="text" value="<?php echo esc_attr( $twitter ); ?>">
                </div>
            </div>
            <div>
                <label for="<?php echo $this->get_field_id( 'instagram' ); ?>">Instagram:</label>
                <div class="fr-input">
                    <span class="dashicons dashicons-instagram"></span>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'instagram' ); ?>" name="<?php echo $this->get_field_name( 'instagram' ); ?>" type="text" value="<?php echo esc_attr( $instagram ); ?>">
                </div>
            </div>
            <div>
                <label for="<?php echo $this->get_field_id( 'youtube' ); ?>">Youtube:</label>
                <div class="fr-input">
                    <span class="dashicons dashicons-youtube"></span>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'youtube' ); ?>" name="<?php echo $this->get_field_name( 'youtube' ); ?>" type="text" value="<?php echo esc_attr( $youtube ); ?>">
                </div>
            </div>

            <div>
                <label for="<?= $this->get_field_id( 'image_uri' ); ?>">Image</label>

                <img class="<?= $this->id ?>_img" src="<?= (!empty($instance['image_uri'])) ? $instance['image_uri'] : ''; ?>" style="margin:0;padding:0;max-width:100%;display:block"/>
                <div class="fr-input">
                    <span class="dashicons dashicons-admin-links"></span>
                    <input type="text" class="widefat <?= $this->id ?>_url" name="<?= $this->get_field_name( 'image_uri' ); ?>" value="<?php echo $image_uri; ?>" />
                </div>
                <input type="button" id="<?= $this->id ?>" class="button button-primary js_custom_upload_media" value="Upload Image" style="margin-top:5px;" />
            </div>
        </div>
        <?php
    }
    #Save Data
    public function update( $new_instance, $old_instance ) {
        // processes widget options to be saved
        foreach( $new_instance as $key => $value )
        {
            $updated_instance[$key] = sanitize_text_field($value);
        }
        $updated_instance['image_uri'] = strip_tags( $new_instance['image_uri'] );
        return $updated_instance;
    }
}