<?php
class TOROFLIX_Admin {
    private $theme_name;
    private $version;
    private $build_menupage;
    private $helpers;
    public function __construct( $theme_name, $version ) {
        $this->theme_name     = $theme_name;
        $this->version        = $version;
        $this->build_menupage = new TOROFLIX_Build_Menupage();
    }
    public function enqueue_styles( $hook ) {
        #Styles General Admin
        wp_enqueue_style( 'peli_wordpress_admin_css', TOROFLIX_DIR_URI . 'admin/css/toroflix-wordpress-global.css', array(), $this->version, 'all' );
        #Style for page custom admin
        if( $hook == 'toplevel_page_report_toroflix' ) {
            wp_enqueue_style( 'bootstrap_css', 'https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/css/bootstrap.min.css', array(), $this->version, 'all' );
        }
    }
    public function enqueue_scripts( $hook ) {
        wp_enqueue_script( 'peli_wordpress_admin_js', TOROFLIX_DIR_URI . 'admin/js/toroflix-wordpress-global.js', [ 'jquery' ], $this->version, true );
        /**
         * Condicional para controlar la carga de los archivos
         * solamente en la página del plugin
         */
        if( $hook == 'toplevel_page_report_toroflix' ) {
            wp_enqueue_media();
            wp_enqueue_script( 'function_admin_js', TOROFLIX_DIR_URI . 'admin/js/toroflix-admin.js', [ 'jquery' ], $this->version, true );
            $function_Admin = [
                'url'   => admin_url( 'admin-ajax.php' ),
                'nonce' => wp_create_nonce( 'function_seg' ),
            ];
            wp_localize_script( 'function_admin_js', 'function_Admin', $function_Admin );
        }
    }


    public function add_menu() {
        $this->build_menupage->add_menu_page(
            __( 'Report', 'toroflix' ),
            __( 'Report', 'toroflix' ),
            'manage_options',
            'report_toroflix',
            [ $this, 'report_toroflix' ]
        );
        $this->build_menupage->run();
    }
    
    public function report_toroflix(){
        require_once TOROFLIX_DIR_PATH . 'admin/partials/toroflix_report_movies_series.php';
    }

    /*ADD MENU PAGE ADMIN*/
    /**
     * Añade los Menus para mostrarlos
     * en el front end
     *  L Menu Header 
     *  L Menu Mobile
     */
    public function toroflix_register_menus() {
        register_nav_menus
        (
            array(
                'header' => __( 'Menu Header', 'toroflix' ),
            )
        );
    }
}
