// Generated by Dagger (https://dagger.dev).
package com.mastercoding.dependencyapp;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import javax.inject.Provider;

@DaggerGenerated
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerMobileComponent implements MobileComponent {
  private final DaggerMobileComponent mobileComponent = this;

  private Provider<Battery> provideBatteryProvider;

  private Provider<CPU> cPUProvider;

  private Provider<Mobile> mobileProvider;

  private DaggerMobileComponent(BatteryModule batteryModuleParam) {

    initialize(batteryModuleParam);

  }

  public static Builder builder() {
    return new Builder();
  }

  @SuppressWarnings("unchecked")
  private void initialize(final BatteryModule batteryModuleParam) {
    this.provideBatteryProvider = BatteryModule_ProvideBatteryFactory.create(batteryModuleParam);
    this.cPUProvider = CPU_Factory.create(Processor_Factory.create());
    this.mobileProvider = DoubleCheck.provider(Mobile_Factory.create(provideBatteryProvider, MemoryCard_Factory.create(), cPUProvider));
  }

  @Override
  public Mobile getMobile() {
    return mobileProvider.get();
  }

  public static final class Builder {
    private BatteryModule batteryModule;

    private Builder() {
    }

    public Builder batteryModule(BatteryModule batteryModule) {
      this.batteryModule = Preconditions.checkNotNull(batteryModule);
      return this;
    }

    public MobileComponent build() {
      Preconditions.checkBuilderRequirement(batteryModule, BatteryModule.class);
      return new DaggerMobileComponent(batteryModule);
    }
  }
}
