// Generated by Dagger (https://dagger.dev).
package com.mastercoding.dependencyapp;

import dagger.internal.DaggerGenerated;
import dagger.internal.Preconditions;

@DaggerGenerated
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerMobileComponent implements MobileComponent {
  private final NickelBatteryModule nickelBatteryModule;

  private final DaggerMobileComponent mobileComponent = this;

  private DaggerMobileComponent(NickelBatteryModule nickelBatteryModuleParam) {
    this.nickelBatteryModule = nickelBatteryModuleParam;

  }

  public static Builder builder() {
    return new Builder();
  }

  public static MobileComponent create() {
    return new Builder().build();
  }

  private Battery battery() {
    return NickelBatteryModule_ProvideNickelBatteryFactory.provideNickelBattery(nickelBatteryModule, new NickelBattery());
  }

  private CPU cPU() {
    return new CPU(new Processor());
  }

  @Override
  public Mobile getMobile() {
    return new Mobile(battery(), new MemoryCard(), cPU());
  }

  public static final class Builder {
    private NickelBatteryModule nickelBatteryModule;

    private Builder() {
    }

    public Builder nickelBatteryModule(NickelBatteryModule nickelBatteryModule) {
      this.nickelBatteryModule = Preconditions.checkNotNull(nickelBatteryModule);
      return this;
    }

    public MobileComponent build() {
      if (nickelBatteryModule == null) {
        this.nickelBatteryModule = new NickelBatteryModule();
      }
      return new DaggerMobileComponent(nickelBatteryModule);
    }
  }
}
