package com.mastercoding.chatapp;

import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import androidx.databinding.DataBinderMapper;
import androidx.databinding.DataBindingComponent;
import androidx.databinding.ViewDataBinding;
import com.mastercoding.chatapp.databinding.ActivityChatBindingImpl;
import com.mastercoding.chatapp.databinding.ActivityGroupsBindingImpl;
import com.mastercoding.chatapp.databinding.ActivityLoginBindingImpl;
import com.mastercoding.chatapp.databinding.DialogLayoutBindingImpl;
import com.mastercoding.chatapp.databinding.ItemCardBindingImpl;
import com.mastercoding.chatapp.databinding.RowChatBindingImpl;
import java.lang.IllegalArgumentException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DataBinderMapperImpl extends DataBinderMapper {
  private static final int LAYOUT_ACTIVITYCHAT = 1;

  private static final int LAYOUT_ACTIVITYGROUPS = 2;

  private static final int LAYOUT_ACTIVITYLOGIN = 3;

  private static final int LAYOUT_DIALOGLAYOUT = 4;

  private static final int LAYOUT_ITEMCARD = 5;

  private static final int LAYOUT_ROWCHAT = 6;

  private static final SparseIntArray INTERNAL_LAYOUT_ID_LOOKUP = new SparseIntArray(6);

  static {
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.mastercoding.chatapp.R.layout.activity_chat, LAYOUT_ACTIVITYCHAT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.mastercoding.chatapp.R.layout.activity_groups, LAYOUT_ACTIVITYGROUPS);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.mastercoding.chatapp.R.layout.activity_login, LAYOUT_ACTIVITYLOGIN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.mastercoding.chatapp.R.layout.dialog_layout, LAYOUT_DIALOGLAYOUT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.mastercoding.chatapp.R.layout.item_card, LAYOUT_ITEMCARD);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.mastercoding.chatapp.R.layout.row_chat, LAYOUT_ROWCHAT);
  }

  @Override
  public ViewDataBinding getDataBinder(DataBindingComponent component, View view, int layoutId) {
    int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
    if(localizedLayoutId > 0) {
      final Object tag = view.getTag();
      if(tag == null) {
        throw new RuntimeException("view must have a tag");
      }
      switch(localizedLayoutId) {
        case  LAYOUT_ACTIVITYCHAT: {
          if ("layout/activity_chat_0".equals(tag)) {
            return new ActivityChatBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_chat is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYGROUPS: {
          if ("layout/activity_groups_0".equals(tag)) {
            return new ActivityGroupsBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_groups is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYLOGIN: {
          if ("layout/activity_login_0".equals(tag)) {
            return new ActivityLoginBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_login is invalid. Received: " + tag);
        }
        case  LAYOUT_DIALOGLAYOUT: {
          if ("layout/dialog_layout_0".equals(tag)) {
            return new DialogLayoutBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for dialog_layout is invalid. Received: " + tag);
        }
        case  LAYOUT_ITEMCARD: {
          if ("layout/item_card_0".equals(tag)) {
            return new ItemCardBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for item_card is invalid. Received: " + tag);
        }
        case  LAYOUT_ROWCHAT: {
          if ("layout/row_chat_0".equals(tag)) {
            return new RowChatBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for row_chat is invalid. Received: " + tag);
        }
      }
    }
    return null;
  }

  @Override
  public ViewDataBinding getDataBinder(DataBindingComponent component, View[] views, int layoutId) {
    if(views == null || views.length == 0) {
      return null;
    }
    int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
    if(localizedLayoutId > 0) {
      final Object tag = views[0].getTag();
      if(tag == null) {
        throw new RuntimeException("view must have a tag");
      }
      switch(localizedLayoutId) {
      }
    }
    return null;
  }

  @Override
  public int getLayoutId(String tag) {
    if (tag == null) {
      return 0;
    }
    Integer tmpVal = InnerLayoutIdLookup.sKeys.get(tag);
    return tmpVal == null ? 0 : tmpVal;
  }

  @Override
  public String convertBrIdToString(int localId) {
    String tmpVal = InnerBrLookup.sKeys.get(localId);
    return tmpVal;
  }

  @Override
  public List<DataBinderMapper> collectDependencies() {
    ArrayList<DataBinderMapper> result = new ArrayList<DataBinderMapper>(1);
    result.add(new androidx.databinding.library.baseAdapters.DataBinderMapperImpl());
    return result;
  }

  private static class InnerBrLookup {
    static final SparseArray<String> sKeys = new SparseArray<String>(4);

    static {
      sKeys.put(0, "_all");
      sKeys.put(1, "chatGroup");
      sKeys.put(2, "chatMessage");
      sKeys.put(3, "vModel");
    }
  }

  private static class InnerLayoutIdLookup {
    static final HashMap<String, Integer> sKeys = new HashMap<String, Integer>(6);

    static {
      sKeys.put("layout/activity_chat_0", com.mastercoding.chatapp.R.layout.activity_chat);
      sKeys.put("layout/activity_groups_0", com.mastercoding.chatapp.R.layout.activity_groups);
      sKeys.put("layout/activity_login_0", com.mastercoding.chatapp.R.layout.activity_login);
      sKeys.put("layout/dialog_layout_0", com.mastercoding.chatapp.R.layout.dialog_layout);
      sKeys.put("layout/item_card_0", com.mastercoding.chatapp.R.layout.item_card);
      sKeys.put("layout/row_chat_0", com.mastercoding.chatapp.R.layout.row_chat);
    }
  }
}
