import { PackageJson } from 'type-fest';
import { BroadcastCacheUpdateOptions } from 'workbox-broadcast-update/BroadcastCacheUpdate';
import { GoogleAnalyticsInitializeOptions } from 'workbox-google-analytics/initialize';
import { HTTPMethod } from 'workbox-routing/utils/constants';
import { QueueOptions } from 'workbox-background-sync/Queue';
import { RouteHandler, RouteMatchCallback } from 'workbox-core/types';
import { CacheableResponseOptions } from 'workbox-cacheable-response/CacheableResponse';
import { ExpirationPluginOptions } from 'workbox-expiration/ExpirationPlugin';
import { WorkboxPlugin } from 'workbox-core/types';
export interface ManifestEntry {
    integrity?: string;
    revision: string | null;
    url: string;
}
declare type StrategyName = 'CacheFirst' | 'CacheOnly' | 'NetworkFirst' | 'NetworkOnly' | 'StaleWhileRevalidate';
export interface RuntimeCaching {
    handler: RouteHandler | StrategyName;
    method?: HTTPMethod;
    options?: {
        backgroundSync?: {
            name: string;
            options?: QueueOptions;
        };
        broadcastUpdate?: {
            channelName?: string;
            options: BroadcastCacheUpdateOptions;
        };
        cacheableResponse?: CacheableResponseOptions;
        cacheName?: string | null;
        expiration?: ExpirationPluginOptions;
        networkTimeoutSeconds?: number;
        plugins?: Array<WorkboxPlugin>;
        precacheFallback?: {
            fallbackURL: string;
        };
        rangeRequests?: boolean;
        fetchOptions?: RequestInit;
        matchOptions?: CacheQueryOptions;
    };
    urlPattern: RegExp | string | RouteMatchCallback;
}
export interface ManifestTransformResult {
    manifest: Array<ManifestEntry & {
        size: number;
    }>;
    warnings?: Array<string>;
}
export declare type ManifestTransform = (manifestEntries: Array<ManifestEntry & {
    size: number;
}>, compilation?: unknown) => Promise<ManifestTransformResult> | ManifestTransformResult;
export interface BasePartial {
    additionalManifestEntries?: Array<string | ManifestEntry>;
    dontCacheBustURLsMatching?: RegExp;
    manifestTransforms?: Array<ManifestTransform>;
    /**
     * @default 2097152
     */
    maximumFileSizeToCacheInBytes?: number;
    modifyURLPrefix?: {
        [key: string]: string;
    };
}
export interface GeneratePartial {
    /**
     * @default ["chrome >= 56"]
     */
    babelPresetEnvTargets?: Array<string>;
    cacheId?: string | null;
    /**
     * @default false
     */
    cleanupOutdatedCaches?: boolean;
    /**
     * @default false
     */
    clientsClaim?: boolean;
    directoryIndex?: string | null;
    /**
     * @default false
     */
    disableDevLogs?: boolean;
    ignoreURLParametersMatching?: Array<RegExp>;
    importScripts?: Array<string>;
    /**
     * @default false
     */
    inlineWorkboxRuntime?: boolean;
    /**
     * @default "production"
     */
    mode?: string | null;
    /**
     * @default null
     */
    navigateFallback?: string | null;
    navigateFallbackAllowlist?: Array<RegExp>;
    navigateFallbackDenylist?: Array<RegExp>;
    /**
     * navigationPreload is only valid when runtimeCaching is configured. However,
     * this can't be expressed via TypeScript, so it's enforced via runtime logic.
     * @default false
     */
    navigationPreload?: boolean;
    /**
     * @default false
     */
    offlineGoogleAnalytics?: boolean | GoogleAnalyticsInitializeOptions;
    runtimeCaching?: Array<RuntimeCaching>;
    /**
     * @default false
     */
    skipWaiting?: boolean;
    /**
     * @default true
     */
    sourcemap?: boolean;
}
export interface RequiredGlobDirectoryPartial {
    globDirectory: string;
}
export interface OptionalGlobDirectoryPartial {
    globDirectory?: string;
}
export interface GlobPartial {
    /**
     * @default true
     */
    globFollow?: boolean;
    /**
     * @default ["**\/node_modules\/**\/*"]
     */
    globIgnores?: Array<string>;
    /**
     * @default ["**\/*.{js,css,html}"]
     */
    globPatterns?: Array<string>;
    /**
     * @default true
     */
    globStrict?: boolean;
    templatedURLs?: {
        [key: string]: string | Array<string>;
    };
}
interface InjectPartial {
    /**
     * @default "self.__WB_MANIFEST"
     */
    injectionPoint?: string;
    swSrc: string;
}
interface WebpackPartial {
    chunks?: Array<string>;
    exclude?: Array<string | RegExp | ((arg0: string) => boolean)>;
    excludeChunks?: Array<string>;
    include?: Array<string | RegExp | ((arg0: string) => boolean)>;
    mode?: string | null;
}
export interface RequiredSWDestPartial {
    swDest: string;
}
interface WebpackGenerateSWPartial {
    importScriptsViaChunks?: Array<string>;
    /**
     * @default "service-worker.js"
     */
    swDest?: string;
}
interface WebpackInjectManifestPartial {
    /**
     * @default true
     */
    compileSrc?: boolean;
    swDest?: string;
    webpackCompilationPlugins?: Array<any>;
}
export declare type GenerateSWOptions = BasePartial & GlobPartial & GeneratePartial & RequiredSWDestPartial & OptionalGlobDirectoryPartial;
export declare type GetManifestOptions = BasePartial & GlobPartial & RequiredGlobDirectoryPartial;
export declare type InjectManifestOptions = BasePartial & GlobPartial & InjectPartial & RequiredSWDestPartial & RequiredGlobDirectoryPartial;
export declare type WebpackGenerateSWOptions = BasePartial & WebpackPartial & GeneratePartial & WebpackGenerateSWPartial;
export declare type WebpackInjectManifestOptions = BasePartial & WebpackPartial & InjectPartial & WebpackInjectManifestPartial;
export interface GetManifestResult {
    count: number;
    manifestEntries: Array<ManifestEntry>;
    size: number;
    warnings: Array<string>;
}
export declare type BuildResult = Omit<GetManifestResult, 'manifestEntries'> & {
    filePaths: Array<string>;
};
export interface FileDetails {
    file: string;
    hash: string;
    size: number;
}
export declare type BuildType = 'dev' | 'prod';
export interface WorkboxPackageJSON extends PackageJson {
    workbox?: {
        browserNamespace?: string;
        packageType?: string;
        prodOnly?: boolean;
    };
}
export {};
